﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace RussianStringconstantEditor
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() != DialogResult.Cancel)
            {
                dataGridView1.Rows.Clear();
                TranslationManager.Parse(openFileDialog1.FileName, textBox1.Text.ToCharArray());
                foreach (string ot in TranslationManager.OriginalText)
                    dataGridView1.Rows.Add(ot, "");

                MessageBox.Show(TranslationManager.OriginalText.Count.ToString() + " записей импортировано!");
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (saveFileDialog2.ShowDialog() != DialogResult.Cancel)
            {
                TranslationManager.OriginalText.Clear();
                TranslationManager.TranslatedText.Clear();
                foreach (DataGridViewRow dgvr in dataGridView1.Rows)
                {
                    TranslationManager.OriginalText.Add(dgvr.Cells[0].Value.ToString());
                    TranslationManager.TranslatedText.Add(dgvr.Cells[1].Value.ToString());
                }

                StringBuilder sb = new StringBuilder();

                for (int i = 0; i < TranslationManager.OriginalText.Count; i++)
                {
                    sb.Append(TranslationManager.OriginalText[i]);
                    sb.Append(Environment.NewLine);
                    sb.Append(TranslationManager.TranslatedText[i]);
                    sb.Append(Environment.NewLine);
                    sb.Append(Environment.NewLine);
                }

                sb.Append("InterText:");
                sb.Append(Environment.NewLine);
                sb.Append(Environment.NewLine);

                for (int i = 0; i < TranslationManager.InterText.Count; i++)
                {
                    sb.Append(TranslationManager.InterText[i]);
                    sb.Append(Environment.NewLine);
                }

                sb.Append("END");

                File.WriteAllText(saveFileDialog2.FileName, sb.ToString());

                MessageBox.Show(TranslationManager.OriginalText.Count.ToString() + " записей сохранено!");
            }
        }

        private void button4_Click(object sender, EventArgs e)
        {
            if (openFileDialog2.ShowDialog() != DialogResult.Cancel)
            {
                TranslationManager.InterText = new List<string>();
                TranslationManager.OriginalText = new List<string>();
                TranslationManager.TranslatedText = new List<string>();

                using (StreamReader sr = new StreamReader(new BufferedStream(new FileStream(openFileDialog2.FileName, FileMode.Open))))
                {
                    string s;

                    while (!sr.EndOfStream)
                    {
                        s = sr.ReadLine();
                        if (s == "InterText:")
                            break;
                        TranslationManager.OriginalText.Add(s);
                        s = sr.ReadLine();
                        TranslationManager.TranslatedText.Add(s);
                        s = sr.ReadLine();//this is just a separator
                    }

                    s = sr.ReadLine();
                    s = sr.ReadLine();

                    while (!sr.EndOfStream)
                    {
                        s = sr.ReadLine();
                        if (s == "END")
                            break;
                        TranslationManager.InterText.Add(s);
                    }

                    dataGridView1.Rows.Clear();
                    for (int i = 0; i < TranslationManager.OriginalText.Count; i++)
                        dataGridView1.Rows.Add(TranslationManager.OriginalText[i], TranslationManager.TranslatedText[i]);

                    MessageBox.Show(TranslationManager.OriginalText.Count.ToString() + " записей загружено!");
                }
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (saveFileDialog1.ShowDialog() != DialogResult.Cancel)
            {
                TranslationManager.OriginalText.Clear();
                TranslationManager.TranslatedText.Clear();
                foreach (DataGridViewRow dgvr in dataGridView1.Rows)
                {
                    TranslationManager.OriginalText.Add(dgvr.Cells[0].Value.ToString());
                    TranslationManager.TranslatedText.Add(dgvr.Cells[1].Value.ToString());
                }

                StringBuilder sb = new StringBuilder();

                for (int i = 0; i < TranslationManager.OriginalText.Count; i++)
                {
                    sb.Append(TranslationManager.InterText[i]);
                    sb.Append(TranslationManager.TranslatedText[i]);
                }
                sb.Append(TranslationManager.InterText[TranslationManager.InterText.Count - 1]);

                File.WriteAllText(saveFileDialog1.FileName, sb.ToString());

                MessageBox.Show(TranslationManager.OriginalText.Count.ToString() + " записей экспортировано!");
            }
        }

        private void button5_Click(object sender, EventArgs e)
        {
            if (saveFileDialog2.ShowDialog() != DialogResult.Cancel)
            {
                TranslationManager.OriginalText.Clear();
                TranslationManager.TranslatedText.Clear();
                foreach (DataGridViewRow dgvr in dataGridView1.Rows)
                {
                    if (!TranslationManager.OriginalText.Contains<string>(dgvr.Cells[0].Value.ToString()))
                    {
                        TranslationManager.OriginalText.Add(dgvr.Cells[0].Value.ToString());
                        TranslationManager.TranslatedText.Add(dgvr.Cells[1].Value.ToString());
                    }
                }

                StringBuilder sb = new StringBuilder();

                for (int i = 0; i < TranslationManager.OriginalText.Count; i++)
                {
                    sb.Append(TranslationManager.OriginalText[i]);
                    sb.Append(Environment.NewLine);
                    sb.Append(TranslationManager.TranslatedText[i]);
                    sb.Append(Environment.NewLine);
                    sb.Append(Environment.NewLine);
                }

                File.WriteAllText(saveFileDialog2.FileName, sb.ToString());

                MessageBox.Show(TranslationManager.OriginalText.Count.ToString() + " записей сохранено!");
            }
        }

        private void button6_Click(object sender, EventArgs e)
        {
            MessageBox.Show(
@"Данная программа написана для проекта перевода игры 'В поисках интернетов'
Привет 'Студии Локатор' и её друзьям!
Xitilon.HD408, май 2016

Обновления:

1.01

Обнуление таблицы при повторном импорте текста из скрипта
Кнопка Инструкция и собственно инструкция
Новая функция - Пропатчить скрипт
В диалогах выбора файлов теперь автоматические расширения (json и txt)

1.02

Исправлен баг с функцией Пропатчить скрипт
Тултипы (подсказки) с инструкциями для каждой конкретной кнопки
Защита от одинаковых выбранных файлов для патча скрипта
Оптимизирован импорт скрипта (StringBuilder вместо string)

1.03

Добавлен выбор дополнительных символов для извлечения (импорта)
", "О программе", MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
        }

        private void button8_Click(object sender, EventArgs e)
        {
            MessageBox.Show(
@"Скрипт:

Импорт - читает выбранный файл и загоняет в таблицу все строки, состоящие из кириллических символов и знаков пунктуации. Вместе с этим программа считывает весь остальной текст во внутренний массив InterText.

Экспорт - пишет в выбранный файл данные из правой колонки таблицы, обрамляя их InterText'ом. Если InterText не загружен, то экспорт невозможен. Загружается через Проект перевода - Открыть либо Импорт.

Пропатчить скрипт - заменяет в первом выбранном файле строки из второго выбранного файла на другие строки из второго выбранного файла, и сохраняет всё это в третий выбранный файл. Первый выбранный файл должен быть скриптом, а второй - файлом трёхстрочного формата, где на каждой N строке оригинал перевода, на каждой (N+1) строке - целевой перевод, а каждая (N+2) строка пустая (либо с комментариями - программой она просто игнорируется). Используется в паре с кнопкой Проект перевода - Сохранить без повторов и кода.


Проект перевода:

Сохранить - сохраняет в выбранный файл оригиналы и переводы в трёхстрочном формате, после чего InterText (промежуточный код скрипта, не включающий в себя строк для перевода)

Открыть - открывает выбранный файл, ранее сохранённый через Сохранить, загружая перевод в таблицу, а InterText - во внутреннюю память

Сохранить без повторов и кода - то же что и Сохранить, но без повторов. Используется в паре с кнопкой Скрипт - Пропатчить скрипт
", "Инструкция", MessageBoxButtons.OK, MessageBoxIcon.Information, MessageBoxDefaultButton.Button1);
        }

        private void button7_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() != DialogResult.Cancel)
            if (openFileDialog2.ShowDialog() != DialogResult.Cancel)
            if (saveFileDialog1.ShowDialog() != DialogResult.Cancel)
            {
                if ((openFileDialog1.FileName == openFileDialog2.FileName)
                 || (openFileDialog2.FileName == saveFileDialog1.FileName)
                 || (saveFileDialog1.FileName == openFileDialog1.FileName))
                {
                    MessageBox.Show("Какие-то из выбранных файлов одинаковы - прочитайте инструкцию и выберите ещё раз.");
                    return;
                }

                string AllText = File.ReadAllText(openFileDialog1.FileName);

                List<string> Original = new List<string>();
                List<string> Translated = new List<string>();

                using (StreamReader sr = new StreamReader(new BufferedStream(new FileStream(openFileDialog2.FileName, FileMode.Open))))
                {
                    string s;

                    while (!sr.EndOfStream)
                    {
                        s = sr.ReadLine();
                        Original.Add(s);
                        s = sr.ReadLine();
                        Translated.Add(s);
                        s = sr.ReadLine();//this is just a separator
                    }

                    //Original and Translated need to be equally reordered from longest to smallest strings - IMPORTANT
                    //Original.OrderBy(x => x.Length); doesn't quite do the thing - not coupled with Translated

                    string temp;
                    for (int i = 0; i < Original.Count; i++)
                        for (int j = i + 1; j < Original.Count; j++)
                        {
                            if (Original[j].Length > Original[i].Length)
                            {
                                temp = Original[i];
                                Original[i] = Original[j];
                                Original[j] = temp;

                                temp = Translated[i];
                                Translated[i] = Translated[j];
                                Translated[j] = temp;
                            }
                        }

                    for (int i = 0; i < Original.Count; i++)
                        AllText = AllText.Replace(Original[i], Translated[i]);
                }

                File.WriteAllText(saveFileDialog1.FileName, AllText);
                MessageBox.Show(Original.Count.ToString() + " записей пропатчено!");
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {

        }
    }

    public static class TranslationManager
    {
        public static List<string> InterText = new List<string>();
        public static List<string> OriginalText = new List<string>();
        public static List<string> TranslatedText = new List<string>();

        static char[] RussianChars = { 'а', 'б', 'в', 'г', 'д', 'е', 'ё', 'ж', 'з', 'и',
                                       'й', 'к', 'л', 'м', 'н', 'о', 'п', 'р', 'с', 'т',
                                       'у', 'ф', 'х', 'ц', 'ч', 'ш', 'щ', 'ь', 'ы', 'ъ',
                                       'э', 'ю', 'я' };
        static char[] AlsoTakeTheseChars = { ' ', '-', ',', '.', '!', '?' };

        public static void Parse(string filename, char[] AlsoTakeTheseChars)
        {
            InterText = new List<string>();
            OriginalText = new List<string>();
            TranslatedText = new List<string>();

            using (StreamReader sr = new StreamReader(new BufferedStream(new FileStream(filename, FileMode.Open))))
            {
                bool in_russian = false;
                char ch;
                StringBuilder buffer = new StringBuilder();

                while (!sr.EndOfStream)
                {
                    ch = (char)(sr.Read());

                    if (!in_russian)
                    {
                        if (RussianChars.Contains<char>(char.ToLower(ch)))
                        {
                            InterText.Add(buffer.ToString());
                            buffer.Clear().Append(ch);
                            in_russian = true;
                        }
                        else
                            buffer.Append(ch);
                    }
                    else
                    {
                        if ((RussianChars.Contains<char>(char.ToLower(ch)))
                        || (AlsoTakeTheseChars.Contains<char>(ch)))
                        {
                            buffer.Append(ch);
                        }
                        else
                        {
                            OriginalText.Add(buffer.ToString());
                            in_russian = false;
                            buffer.Clear().Append(ch);
                        }
                    }
                }

                InterText.Add(buffer.ToString());
            }
        }
    }
}